@echo off
setlocal enabledelayedexpansion
title CLS Team - Gaming Boost

echo CLS Team - Gaming Performance Optimizer
echo =======================================

echo [1/3] Enabling Gaming Mode...
reg add "HKCU\Software\Microsoft\GameBar" /v "AllowAutoGameMode" /t REG_DWORD /d 1 /f >nul
reg add "HKCU\Software\Microsoft\GameBar" /v "AutoGameModeEnabled" /t REG_DWORD /d 1 /f >nul
echo Gaming Mode enabled.

echo [2/3] Enabling Hardware Acceleration...
reg add "HKCU\Software\Microsoft\DirectX\UserGpuPreferences" /v "DirectXUserGlobalSettings" /t REG_SZ /d "HardwareAcceleratedGPU scheduling=1;" /f >nul 2>&1
reg add "HKCU\Control Panel\Desktop" /v "UserPreferencesMask" /t REG_BINARY /d 9032080000000000 /f >nul 2>&1

REM Enable hardware GPU scheduling
reg add "HKLM\SYSTEM\CurrentControlSet\Control\GraphicsDrivers" /v "HwSchMode" /t REG_DWORD /d 2 /f >nul 2>&1

REM Disable fullscreen optimizations globally
reg add "HKCU\System\GameConfigStore" /v "GameDVR_DXGIHonorFSEWindowsCompatible" /t REG_DWORD /d 1 /f >nul
reg add "HKCU\System\GameConfigStore" /v "GameDVR_HonorUserFSEBehaviorMode" /t REG_DWORD /d 1 /f >nul
echo Hardware acceleration optimized.

echo [3/3] Setting Power Plan to High Performance...
powercfg /setactive 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c >nul
if %errorlevel% neq 0 (
    echo Creating High Performance power plan...
    powercfg -duplicatescheme 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c >nul
    powercfg /setactive 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c >nul
)

REM Disable USB selective suspend
powercfg /setacvalueindex SCHEME_CURRENT 2a737441-1930-4402-8d77-b2bebba308a3 48e6b7a6-50f5-4782-a5d4-53bb8f07e226 0 >nul
powercfg /setdcvalueindex SCHEME_CURRENT 2a737441-1930-4402-8d77-b2bebba308a3 48e6b7a6-50f5-4782-a5d4-53bb8f07e226 0 >nul

REM Set processor performance to 100%
powercfg /setacvalueindex SCHEME_CURRENT 54533251-82be-4824-96c1-47b60b740d00 893dee8e-2bef-41e0-89c6-b55d0929964c 100 >nul
powercfg /setdcvalueindex SCHEME_CURRENT 54533251-82be-4824-96c1-47b60b740d00 893dee8e-2bef-41e0-89c6-b55d0929964c 100 >nul

echo High Performance power plan activated.

echo.
echo [BONUS] Applying Game DVR and Background Process Optimizations...

REM Disable Game Bar
reg add "HKCU\Software\Microsoft\GameBar" /v "ShowStartupPanel" /t REG_DWORD /d 0 /f >nul
reg add "HKCU\System\GameConfigStore" /v "GameDVR_Enabled" /t REG_DWORD /d 0 /f >nul

REM Enable performance tweaks
reg add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Multimedia\SystemProfile" /v "NetworkThrottlingIndex" /t REG_DWORD /d 4294967295 /f >nul
reg add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Multimedia\SystemProfile" /v "SystemResponsiveness" /t REG_DWORD /d 0 /f >nul

REM Game Mode registry entries
reg add "HKLM\SOFTWARE\Microsoft\PolicyManager\default\ApplicationManagement\AllowGameDVR" /v "value" /t REG_DWORD /d 1 /f >nul 2>&1
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\GameDVR" /v "AllowGameDVR" /t REG_DWORD /d 1 /f >nul 2>&1

echo.
echo Verifying settings...
echo ====================

REM Verify power plan
for /f "tokens=*" %%I in ('powercfg /getactivescheme') do set "powerPlan=%%I"
echo Active Power Plan: !powerPlan!

REM Verify gaming mode
reg query "HKCU\Software\Microsoft\GameBar" /v "AutoGameModeEnabled" >nul && echo Gaming Mode: ENABLED || echo Gaming Mode: DISABLED

echo.
echo =======================================
echo GAMING BOOST COMPLETE!
echo.
echo Recommended: Restart your system for all changes to take effect.
echo.
pause